# -*- encoding: utf-8 -*-
# Miweather specification file
# Created with sur-0.2
Sur::Specification.new do |s|
  # Sublet information
  s.name        = "Miweather"
  s.version     = "0.8"
  s.tags        = [ "Config", "Weather" ]
  s.files       = [ "miweather.rb" ]
  s.icons       = [ "icons/lluvia2.xbm", "icons/lluvia.xbm", "icons/nieve.xbm", "icons/nube.xbm", "icons/sol.xbm", "icons/lluviasol.xbm", "icons/niebla.xbm", "icons/nubesol.xbm", "icons/sol2.xbm", "icons/nada.xbm", "icons/tormenta.xbm" ]

  # Sublet description
  s.description = "Weather info sublet that gets information from http://wttr.in."
  s.notes       = <<NOTES
Miweather displays meteorological information (temperature, weather) fetched from http://wttr.in, with custom XBM or unicode icons. You can configure up to five different locations from all around the world. And you can get that information in many languages. Visit https://github.com/chubin/wttr.in for more details.
NOTES

  # Sublet authors
  s.authors     = [ "Eye del Cul" ]
  s.contact     = "sovietskayarodina@gmail.com"
  s.date        = "Sun Apr 05 23:53 CEST 2020"

  # Sublet config
  s.config = [
    {
      :name        => "interval",
      :type        => "integer",
      :description => "Update interval in seconds.",
      :def_value   => "1800"
    },
    {
      :name        => "placeone",
      :type        => "string",
      :description => "First location to show weather info of. Admits spaces.",
      :def_value   => "Valencia"
    },
    {
      :name        => "placetwo",
      :type        => "string",
      :description => "Second location to show weather info of (optional).",
      :def_value   => ""
    },
    {
      :name        => "placethree",
      :type        => "string",
      :description => "Third location to show weather info of (optional).",
      :def_value   => ""
    },
    {
      :name        => "placefour",
      :type        => "string",
      :description => "Fourth location to show weather info of (optional).",
      :def_value   => ""
    },
    {
      :name        => "placefive",
      :type        => "string",
      :description => "Fifth location to show weather info of (optional).",
      :def_value   => ""
    },
    {
      :name        => "lang",
      :type        => "string",
      :description => "Language (ISO 2 letter code: en, es, ru, sr, etc).",
      :def_value   => "en"
    },
    {
      :name        => "unit",
      :type        => "string",
      :description => "Metric units (m) or funny USCS units (u)",
      :def_value   => "m"
    },
    {
      :name        => "xbmicon",
      :type        => "string",
      :description => "Unicode weather emojis (\"no\") or XBM icons (\"yes\").",
      :def_value   => "yes"
    },
    {
      :name        => "wind",
      :type        => "string",
      :description => "Show wind direction and speed (\"yes\" or \"no\").",
      :def_value   => "yes"
    },
    {
      :name        => "separator",
      :type        => "string",
      :description => "Text separator between the info of various locations.",
      :def_value   => "|"
    }
  ]

  # Sublet grabs
  #s.grabs = {
  #  :MiweatherGrab => "Sublet grab"
  #}

  # Sublet requirements
  # s.required_version = "0.9.2127"
  # s.add_dependency("subtle", "~> 0.1.2")
end
