# Arbi_disksstat sublet file
# Created with sur-0.2

require 'arbi'

configure :arbi_disksstat do |s|
  s.interval  = 60
  s.icon      = Subtlext::Icon.new('fs.xbm')
  s.disks     = s.config[:disks] || []
  Arbi.connect
end

on :run do |s|
  data = begin
    Arbi.get('diskstat').data.select {|mount|
      s.disks.include?(mount['device']) or s.disks.include?(mount['point'])
    }.map {|mount|
      "#{mount['point']} #{mount['usage']}"
    }.uniq.join(" ")
  rescue Exception => e
    STDERR.puts(e.to_s + "\n" + e.backtrace.join("\n"))
    ""
  end
  s.data = (data.empty? ? '' : s.icon.to_s + " ") + data
end
