module Arbi
    require 'socket'

    def self.connect address = '127.0.0.1', port = '6969'
        @@connection = TCPSocket.new address, port
        @@connection.print "SERIAL\r\n"
    end

    def self.connected?
        return true if @@connection
        false
    end

    def self.connection
        @@connection
    end

    def self.get what
        self.connect unless self.connected?
        @@connection.print what + "\r\n"
        eval @@connection.gets.strip
    end
end

configure :arbi_disksstat do |s|
  Arbi.connect
  s.interval = 60
  s.icon = Subtlext::Icon.new('fs.xbm')
  s.disks = (File.read(File.join(ENV['HOME'], '.config', 'subtle', 'disks')).strip.split(/\s+/) rescue [])
end

on :run do |s|
    begin
        data = (Arbi.get('diskstats').map { |disk|
            "#{disk['point']} #{disk['usage']}" if s.disks.include?(disk['device'])
        } - [nil]).join(' ')
        s.data = s.icon + " " + (data.empty? ? "No disks" : data)
    rescue e
        s.data = s.icon + " No disks"
        p e
    end
end
