# Subrss sublet file
# Created with sur-0.2


require 'rss/1.0'
require 'rss/2.0'
require 'open-uri'

configure :subrss do |s|
    s.interval = s.config[:interval] || 5
    s.icon = Subtlext::Icon.new("rss.xbm")
#    s.src = "http://feeds2.feedburner.com/hackaday/LgoM"
    s.src = s.config[:source] || "http://feeds2.feedburner.com/hackaday/LgoM"
end

on :mouse_down do |s, x, y, button|
    t = Thread.new {system %@xxxterm -e "tabnew #{s.link}"@}
    Thread.pass (t)
end

on :run do |s|
    source = s.src # url or local file
    content = "" # raw content of rss feed will be loaded here
    open(source) do |s| content = s.read end
    rss = RSS::Parser.parse(content, false)
    case Time.now.strftime("%S").to_i
       when  0..9  then s.data= @icon + "%s" % [rss.items[0].title ]
           s.link = rss.items[0].link
       when 10..19 then s.data= @icon + "%s" % [rss.items[1].title ]
           s.link = rss.items[1].link
       when 20..29 then s.data= @icon + "%s" % [rss.items[2].title ]
           s.link = rss.items[2].link
       when 30..39 then s.data= @icon + "%s" % [rss.items[3].title ]
           s.link = rss.items[3].link
       when 40..49 then s.data= @icon + "%s" % [rss.items[4].title ]
           s.link = rss.items[4].link
       when 50..59 then s.data= @icon + "%s" % [rss.items[5].title ]
           s.link = rss.items[5].link

    end
end
