# Arbi_disksstat sublet file
# Created with sur-0.2.165
require 'arbi'

configure :arbi_disksstat do |s|
  s.interval = 60
  s.icon = Subtlext::Icon.new('fs.xbm')
  s.disks = (File.read(File.join(ENV['HOME'], '.config', 'subtle', 'disks')).strip.split(/\s+/) rescue [])
end

on :run do |s|
    begin
        data = (Arbi.get('diskstats').map { |disk|
            "#{disk['point']} #{disk['usage']}" if s.disks.include?(disk['device'])
        } - [nil]).join(' ')
        s.data = s.icon + " " + (data.empty? ? "No disks" : data)
    rescue e
        s.data = s.icon + " No disks"
        p e
    end
end
