configure :alsavol do |s|
  s.interval = 1
  s.format = Proc.new { |volume| "#{volume}%" }
  s.device = "Master"
end


def get_device(dev = "Master")
  `amixer get "#{dev}"`.chop
end

def get_volume(dev = "Master")
  matches = get_device(dev).match(/\[([0-9]+)%\]/)
  if matches.nil? || matches.captures.length != 1
    return -1
  end

  matches.captures[0].to_i
end

def is_muted?(dev = "Master")
  matches = get_device(dev).match(/\[(on|off)\]/)
  if matches.nil? || matches.captures.length != 1
    return true
  end

  matches.captures[0] == "off"
end

on :run do |s|
  volume = get_volume(s.device)
  muted = is_muted?(s.device)

  s.data = s.format.call(volume, muted)
end
                                          