# Lk_ping sublet file
# Created with sur-0.2
#


helper do

  def dns_get
    dns_file = "/etc/resolv.conf"
    ret = ""
    if File.exist?(dns_file)
        file = IO.readlines(dns_file).join
        file.scan(/nameserver (\d+).(\d+).(\d+).(\d+)/) do |ip| 
            ret = ip.join(".")
        end
    end
    ret
  end

  def ping
    self.addr = dns_get if self.addr == nil
    IO.popen(["ping", self.addr, "-c 1", "-W 1"].join(" ")) do |f|
      while !f.eof?
        line = f.gets
        line.scan(/.+time=(\d+)/) do |time|
            self.data = dns_get + " " + time.first.to_s + "ms"
        end
      end
    end
  end 
end

configure :lk_ping do |s|
  s.interval = 60
end

on :run do |s|
  ping
end
